<?php
session_start();
@include "connection.php";
@include "config.php";

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$msg = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {

    // Validate email
    if (empty(trim($_POST["email"]))) {
        $msg = "Please enter an email.";
    } elseif (!filter_var(trim($_POST["email"]), FILTER_VALIDATE_EMAIL)) {
        $msg = "Please enter a valid email address.";
    } else {
        // Check if email already exists
        $sql = "SELECT id FROM users WHERE email = ?";
        if ($stmt = mysqli_prepare($conn, $sql)) {
            mysqli_stmt_bind_param($stmt, "s", $param_email);
            $param_email = trim($_POST["email"]);
            if (mysqli_stmt_execute($stmt)) {
                mysqli_stmt_store_result($stmt);
                if (mysqli_stmt_num_rows($stmt) > 0) {
                    $msg = "This email is already taken.";
                } else {
                    $email = $param_email;
                }
            } else {
                $msg = "Error checking email. Please try again later.";
            }
            mysqli_stmt_close($stmt);
        }
    }

    // Validate password
    if (empty(trim($_POST["password"]))) {
        $msg = "Please enter a password.";
    } elseif (strlen(trim($_POST["password"])) < 6) {
        $msg = "Password must have at least 6 characters.";
    } else {
        $password = trim($_POST["password"]);
    }

    // Validate fname
    if (empty(trim($_POST["fname"]))) {
        $msg = "Please enter your first name.";
    } else {
        $fname = trim($_POST["fname"]);
    }

    // Validate lname
    if (empty(trim($_POST["lname"]))) {
        $msg = "Please enter your last name.";
    } else {
        $lname = trim($_POST["lname"]);
    }

    // Check input errors before inserting into the database
    if (empty($msg)) {

        $widcode = strtoupper(substr(md5($fname), 0, 4) . "-XT");
        $profile = 'User-avatar.png';
        $status = "active";
        $note = 'Your account has been activated';
        $wth = "btc";

        // Insert into the database
        $sql = "INSERT INTO users ( email, password, fname, lname, wth) 
                VALUES (?, ?, ?, ?, ?)";
        if ($stmt = mysqli_prepare($conn, $sql)) {
            mysqli_stmt_bind_param($stmt, "sssss", 
                $email, $password, $fname, $lname, $wth);
            
            if (mysqli_stmt_execute($stmt)) {
                // Send welcome email
                require_once "PHPMailer/PHPMailer.php";
                require_once "PHPMailer/Exception.php";

                $mail = new PHPMailer;
                $mail->setFrom($emaila, $name);
                $mail->addAddress($email);
                $mail->isHTML(true);
                $mail->Subject = "Welcome Message";
                $mail->Body = '<body>
<div style="padding:0px; width:100%; height: auto; background:#fff; border: 2px solid #04999F;">
    <div style="padding:20px; width:100%; height: auto;">
        <img src="https://' . $bankurl . '/libs/img/NET.png" alt="Logo" style="width:50%" />
    </div>
    <br />
    <div style="text-align:left; padding:20px">
        <p>Hello ' . $fname . ' ' . $lname . ', <br /></p>
        <p>
            Your registration is complete and your account has been verified and you have been granted unlimited access to the premium features available on the platform.<br /><br />
            We offer advanced trading services with easy-to-use interface to satisfy both beginners and expert traders.<br />
            You can now log into your account portfolio here: <a href="' . $bankurl . '/accounts/login">' . $bankurl . '/accounts/login</a>
            <br />
            Get to know us better with the articles below!<br />
            <ul>
                <li>About ' . $name . ' - <a href="' . $bankurl . '">' . $bankurl . '</a></li>
                <li>Frequently Asked Questions - <a href="https://' . $bankurl . '/faq">' . $bankurl . '/faq</a></li>
            </ul>
            <br />
            Should you have any questions or concerns, feel free to contact our support team via email at <a href="mailto:' . $emaila . '">' . $emaila . '</a> or chat with us on site at <a href="https://' . $bankurl . '">' . $name . '</a>.<br />
            <br />
            Best Wishes!<br />
            ' . $name . ' Ltd<br/>
            <a href="https://' . $bankurl . '">' . $bankurl . '</a><br/>
            <br />
        </p>
    </div>
    <div style="padding:10px 0px; width:100%; height: auto; border-top: 4px solid #283eff">
        <center>
            &copy; 2025 ' . $name . ' Ltd. All Rights Reserved.<br />
            ' . $name . 'mark
        </center>
    </div>
</div>
</body>
</html>';

                if (!$mail->send()) {
                    $msg = "Mailer Error: " . $mail->ErrorInfo;
                } else {
                    $msg = "We have sent a welcome message to your email.";
                }

                // Notify admin
                $adminMail = new PHPMailer;
                $adminMail->setFrom($emaila, $name);
                $adminMail->addAddress($branch);
                $adminMail->isHTML(true);
                $adminMail->Subject = "New User Registration";
                $adminMail->Body = "<p>Registration Time: " . date('Y-m-d H:i:s') . "</p> 
                                    <p>A new user has registered: $fname $lname ($email)</p>";

                if (!$adminMail->send()) {
                    $msg = "Admin Mailer Error: " . $adminMail->ErrorInfo;
                } else {
                    // ✅ Redirect to dashboard instead of signin
                    echo "<script>window.location.href='signin';</script>";
                    exit;
                }
            } else {
                $msg = "Error inserting data. Please try again.";
            }
            mysqli_stmt_close($stmt);
        }
    }
}
mysqli_close($conn);
?>